const express = require('express');
const dotenv = require('dotenv');
const app = express();
const bodyParser = require('body-parser');
const Rastreos = require('./src/routes/index');

app.set('view engine', 'ejs');
app.set('views', __dirname+'/src'+'/views');
app.use(express.static('src/public'));
app.use(bodyParser.urlencoded({
  extended: true,
     parameterLimit: 10000,
     limit: 1024 * 1024 * 10
}));
app.use(bodyParser.json({limit: '50mb'}));
app.use(express.urlencoded({extended: true}));
app.use(express.json());

app.use('/servicios-de-rastreos', Rastreos);

dotenv.config({path: 'src/env/.env'});


app.listen(process.env.PORT, ()=>{
    console.log('SERVIDOR INICIADO EN EL PUERTO: '+ process.env.PORT);
})